<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\WebhookController;
use App\Http\Controllers\PerfumeController;
use Illuminate\Support\Facades\Storage;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::post('webhook/ultramsg', [WebhookController::class, 'handle']);

Route::post('perfumes/insertar', [PerfumeController::class, 'store']);
Route::get('perfumes/insertar2/{datos}', [PerfumeController::class, 'store2']);
Route::get('perfumes/insertardetalle/{datos}', [PerfumeController::class, 'insertardetalle']);


Route::get('documents/{filename}', function ($filename) {
    $path = storage_path('app/public/documents/' . $filename);

    if (!Storage::disk('public')->exists('documents/' . $filename)) {
        abort(404);
    }

    return response()->file($path);
})->name('documents.show');
