<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class Sesiones extends Model
{
    use HasFactory;
    protected $table = 'sesiones';
    protected $fillable = [
        'idusuario',
        'paso',
        'paso2',
    ];
    protected $primaryKey = 'idusuario';
    public static function actualizarPaso($idUsuario, $nuevoPaso)
    {
        // Buscar la sesión del usuario por su ID
        $sesion = static::where('idusuario', $idUsuario)->first();

        if ($sesion) {
            // Actualizar el paso
            $sesion->paso = $nuevoPaso;
            $sesion->save();
        }
    }
    public static function actualizarPaso2($idUsuario, $nuevoPaso)
    {
        // Buscar la sesión del usuario por su ID
        $sesion = static::where('idusuario', $idUsuario)->first();

        if ($sesion) {
            // Actualizar el paso
            $sesion->paso2 = $nuevoPaso;
            $sesion->save();
        }
    }
    public static function ObtenerPaso2($idUsuario)
    {
      $sesion = static::where('idusuario', $idUsuario)->first();
      if ($sesion) {
        return $sesion->paso2;
      }else{
        return false;
      }
    }
    public static function actualizarYObtenerPaso($idUsuario)
    {
        // Buscar la sesión del usuario por su ID
        $sesion = static::where('idusuario', $idUsuario)->first();

        if ($sesion) {
            // Verificar si han pasado 10 minutos desde la última actualización
            $ultimaActualizacion = Carbon::parse($sesion->updated_at);
            $diferenciaMinutos = Carbon::now()->diffInMinutes($ultimaActualizacion);

            if($sesion->paso!='asesor'){
              if ($diferenciaMinutos >= 10) {
                  // Actualizar el paso a 'menu'
                  $sesion->paso = 'menu';
                  $sesion->save();
              }
            }else{
              if ($diferenciaMinutos >= 60) {
                  // Actualizar el paso a 'menu'
                  $sesion->paso = 'menu';
                  $sesion->save();
              }
            }


            // Devolver el valor actual de "paso"
            return $sesion->paso;
        } else {
          $nuevaSesion = new Sesiones();
          $nuevaSesion->idusuario = $idUsuario;
          $nuevaSesion->paso = 'menu';
          $nuevaSesion->save();

          // Devolver 'menu' como el valor de paso para la nueva sesión
          return 'menu';
        }
    }
}
