<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class BatchStu extends Model
{
    public static function buscarFacilitador($curpOrUsuario)
    {
      return DB::table('sicaedu_conrumbo.batch_stu as a')
            ->select('a.id', 'a.course_id', 'a.batch_id', 'a.grupo', 'a.stu_id', 'b.course_name', 'b.course_code', 'c.batch_name', 'd.stu_first_name', 'd.stu_last_name', 'd.stu_middle_name', 'd.stu_gender', 'a.matricula', 'c.batch_alias', 'a.modalidad', 'c.grupo1', 'c.grupo2', 'c.grupo3', 'c.numero_presenciales', 'c.numero_zoom', 'c.numero_modulos', 'a.modulo_calif_1', 'a.modulo_calif_2', 'a.modulo_calif_3', 'a.modulo_calif_4', 'a.modulo_calif_5', 'a.modulo_sesion_1', 'a.modulo_sesion_2', 'a.modulo_sesion_3', 'a.modulo_sesion_4', 'a.modulo_sesion_5', 'a.modulo_zoom_1', 'a.modulo_zoom_2', 'a.modulo_zoom_3', 'a.modulo_zoom_4', 'a.modulo_zoom_5', 'a.calificacion_final', 'a.observaciones', 'a.region', 'd.stu_curp', 'c.start_date', 'c.end_date', 'c.sede_estado', 'a.grupo', 'd.cct_funcion', 'd.cct_nivel', 'd.stu_mobile_no', 'd.stu_email_id', 'd.stu_rfc', 'd.stu_dob', 'd.stu_gender', 'd.cct_clave', 'd.cct_funcion', 'd.cct_estado', 'd.cct_municipio', 'd.cct_localidad', 'd.cct_ze', 'd.stu_email_alterno', 'ii.nombre as nombre_institucion', 'bf.nombre_grupo', 'ee.emp_first_name', 'ee.emp_last_name', 'ee.emp_middle_name','ee.emp_email_id','ee.emp_mobile_no', 'bf.region', 'ca.country_name', 'st.state_name', DB::raw('YEAR(CURDATE())-YEAR(d.stu_dob) AS edad'), 'a.usuario', 'a.contrasenia', 'a.autodiagnostico', 'a.estatus_contacto', 'a.plataforma1', 'a.plataforma2', 'a.otro', 'a.otro2', 'a.otro3', 'a.enlace_wa', 'a.fecha_alta', 'a.fecha_ultima_conexion', 'a.num_conexiones', 'c.extraer_lms')
            ->leftJoin('sicaedu_conrumbo.courses as b', 'a.course_id', '=', 'b.course_id')
            ->leftJoin('sicaedu_conrumbo.batches as c', 'c.batch_id', '=', 'a.batch_id')
            ->leftJoin('sicaedu_conrumbo.stu_info as d', 'd.stu_unique_id', '=', 'a.stu_id')
            ->leftJoin('sicaedu_conrumbo.ins as ii', 'ii.id', '=', 'id_institucion')
            ->leftJoin('sicaedu_conrumbo.batch_facilitadores as bf', 'bf.id', '=', 'a.grupo')
            ->leftJoin('sicaedu_conrumbo.emp_info as ee', 'ee.emp_info_emp_master_id', '=', 'bf.id_facilitador')
            ->leftJoin('sicaedu_conrumbo.country as ca', 'ca.country_id', '=', 'c.sede_pais')
            ->leftJoin('sicaedu_conrumbo.state as st', 'st.state_id', '=', 'c.sede_estado')
            ->where('a.section_id', 1)

            ->where(function ($query) use ($curpOrUsuario) {
                $query->where('d.stu_curp', $curpOrUsuario)
                      ->orWhere('d.stu_mobile_no', $curpOrUsuario)
                      ->orWhere('a.usuario', $curpOrUsuario);
            })
            ->orderBy('d.stu_last_name')
            ->orderBy('d.stu_middle_name')
            ->orderBy('d.stu_first_name')
            ->orderBy('a.grupo')
            ->first();

    }
    public static function buscarPorCurpOUsuario($curpOrUsuario)
    {
        return DB::table('sicaedu_conrumbo.batch_stu as a')
            ->select('a.id', 'c.calif_aprobatoria', 'b.course_name', 'de.calificacion_final', 'd.stu_curp', 'd.stu_first_name', 'd.stu_middle_name', 'd.stu_last_name', 'a.usuario')
            ->leftJoin('sicaedu_conrumbo.courses as b', 'a.course_id', '=', 'b.course_id')
            ->leftJoin('sicaedu_conrumbo.batches as c', 'c.batch_id', '=', 'a.batch_id')
            ->leftJoin('sicaedu_conrumbo.stu_info as d', 'a.stu_id', '=', 'd.stu_unique_id')
            ->leftJoin('sicaedu_conrumbo.batch_stu_detalles as de', 'de.id_batch_stu', '=', 'a.id')
            ->where(function ($query) use ($curpOrUsuario) {
                $query->where('d.stu_curp', $curpOrUsuario)
                      ->orWhere('d.stu_mobile_no', $curpOrUsuario)
                      ->orWhere('a.usuario', $curpOrUsuario);
            })
            ->orderBy('a.id', 'desc') // Agrega el orderBy aquí
            // ->get();
            ->first();
    }
}
