<?php
// app/Http/Controllers/WebhookController.php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

use App\Models\Webhook;
use App\Models\Ultramsg_mensajes;
use App\Models\Sesiones;
use App\Models\BatchStu;

use UltraMsg\WhatsAppApi;
use App\Http\Controllers\CorreoController;

class WebhookController extends Controller
{
    public function handle(Request $request)
    {
      $correoController = new CorreoController();
      $correoController->enviarCorreo('mo.rodrigo@gmail.com', 'Asunto del correo', 'Contenido del correo');
        // Process webhook payload
        // Perform actions based on the webhook data
        $teacher = new webhook;
        $teacher->contenido = json_encode($request->all());
        $teacher->save();

        $msj = new Ultramsg_mensajes;

        $menuprincipal="Por Favor escribe una de las siguientes opciones:\n".
              "*1. - ¿Quién es mi asesor académico?*\n".
              "*2. - ¿Quiero conocer mi usuario y contraseña?*\n".
              "*3. - ¿Cómo ingreso al Campus Virtual?*\n".
              "*4. - Tengo dudas respecto de las actividades o fechas  de mi curso*\n".
              "*5. - Tengo dudas respecto de las entregas de productos de mi curso*\n".
              "*6. - Mi nombre es incorrecto*\n".
              "*7. - Si concluí las actividades y acredité mi curso, ¿Cómo puedo obtener mi constancia?*\n".
              "*8. - No encuentro mi requimiento en el Menú, solicito comunicarme con el Ejecutivo de Atención a Usuarios*\n";


        $msj->event_type = ($request->event_type);
        $msj->_id = ($request->data['id']);
        $msj->_from = ($request->data['from']);
        $msj->_author = ($request->data['author']);
        $msj->_pushname = ($request->data['pushname']);
        $msj->_ack = ($request->data['ack']);
        $msj->_type = ($request->data['type']);
        $msj->_body = ($request->data['body']);
        $msj->_media = ($request->data['media']);
        $msj->_fromMe = ($request->data['fromMe']);
        $msj->_self = ($request->data['self']);
        $msj->_isForwarded = ($request->data['isForwarded']);
        $msj->_isMentioned = ($request->data['isMentioned']);
        $msj->_quotedMsg = json_encode($request->data['quotedMsg']);
        $msj->_mentionedIds = json_encode($request->data['mentionedIds']);
        $msj->_time = ($request->data['time']);
        $msj->save();

        $ultramsg_token="08k2g808e4uxq3lm"; // Ultramsg.com token
$instance_id="instance80209"; // Ultramsg.com instance id
$client = new WhatsAppApi($ultramsg_token,$instance_id);
$priority=5;
$to=$request->data['from'];
$referenceId=$to.'-'.rand();

$paso = Sesiones::actualizarYObtenerPaso($to);
$paso2 = Sesiones::ObtenerPaso2($to);

// die();
$body2=false;

if($paso=='menu'){
  if($request->data['body']=='1' || $request->data['body']=='asesor'){
    Sesiones::actualizarPaso($to,'asesor');
    $body="¡Con gusto! Escribe tu celular a 10 dígitos, curp o usuario";
    // $body="No disponible.";
    //Sesiones::actualizarPaso($to,'menu');
  }elseif ($request->data['body']=='2' || $request->data['body']=='accesos') {
    Sesiones::actualizarPaso($to,'accesos');
    $body="¡Con gusto! Escribe tu celular a 10 dígitos, curp o usuario";
  }elseif ($request->data['body']=='3' || $request->data['body']=='campus') {
    Sesiones::actualizarPaso($to,'campus');
    $body="Para ingresar al Campus Virtual, ingrese la siguiente dirección en su navegador: *https://conrumbo.org/campusvirtual/*, posterior ingrese su usuario y contraseña. Si los desconoce, seleccione la opción 2 del menú.";
    $body2="¡Ha sido un gusto atenderte! Te envío la Guía de Navegación para resolver tus dudas. Saludos.";
    Sesiones::actualizarPaso($to,'menu');
  }elseif ($request->data['body']=='4' || $request->data['body']=='dudas_actividades') {
    Sesiones::actualizarPaso($to,'dudas_actividades');
    $body="¡Con gusto! Para poder dirigirte con la persona adecuada, por favor escribe tu celular a 10 dígitos, curp o usuario";
    // $body="Sera comunicado con un asesor";
  }elseif ($request->data['body']=='5' || $request->data['body']=='dudas_entregas') {
    Sesiones::actualizarPaso($to,'dudas_entregas');
    $body="¡Con gusto! Para poder dirigirte con la persona adecuada, por favor escribe tu celular a 10 dígitos, curp o usuario";
  }elseif ($request->data['body']=='6' || $request->data['body']=='nombre_incorrecto') {
    Sesiones::actualizarPaso($to,'nombre_incorrecto');
    $body="¡Con gusto! Para resolver tu solicitud, por favor escribe tu celular a 10 dígitos, curp o usuario";
  }elseif ($request->data['body']=='7' || $request->data['body']=='constancia') {
    Sesiones::actualizarPaso($to,'constancia');
    $body="¡Con gusto! Por favor escribe tu celular a 10 dígitos, curp o usuario para verificar la información";
    // $body="No disponible.";
    //Sesiones::actualizarPaso($to,'menu');
  }elseif ($request->data['body']=='8' || $request->data['body']=='comunicarme') {
    Sesiones::actualizarPaso($to,'comunicarme');
    $body="¡Con gusto! Por favor escribe tu nombre, tu usuario y el nombre de tu curso. Realiza una breve descripción de tu requerimiento.";
  }else{

    $body="¡Hola! Gracias por utilizar la Mesa de Ayuda de ConRumbo. ¿Cómo te puedo ayudar? Selecciona una de las siguientes opciones. Si requieres otro tipo de atención, por favor escribe \"quiero comunicarme con un ejecutivo\"";

    $api=$client->sendChatMessage($to,$body,$priority,$referenceId);

    $body=$menuprincipal;
  }

}elseif ($paso=='asesor') {
  $busqueda = BatchStu::buscarFacilitador($request->data['body']);
  if ($busqueda === null) {
      $body ="No se encontraron resultados para el criterio de búsqueda, intenta nuevamente \n Escribe tu celular a 10 dígitos, curp o usuario";
  } else {
    $body ="Tu asesor académico es: *".$busqueda->emp_first_name. ' ' .$busqueda->emp_last_name. ' ' .$busqueda->emp_middle_name. "*\n";
     $body.="Celular: *".$busqueda->emp_mobile_no."*\n";
     $body.="Correo electrónico: *".$busqueda->emp_email_id."*";
     $body2="¿Te puedo ayudar en algo más? \n\n".$menuprincipal;
    Sesiones::actualizarPaso($to,'menu');
  }
}elseif (($paso=='comunicarme')) {
  //Sesiones::actualizarPaso($to,'menu');
}elseif (($paso=='campus')) {
    Sesiones::actualizarPaso($to,'menu');
}elseif (($paso=='dudas_actividades')) {
  $busqueda = BatchStu::buscarFacilitador($request->data['body']);
    if ($busqueda === null) {
        $body ="No se encontraron resultados para el criterio de búsqueda, intenta nuevamente \n Escribe tu celular a 10 dígitos, curp o usuario";
    } else {
      $body ="Tu asesor académico es: *".$busqueda->emp_first_name. ' ' .$busqueda->emp_last_name. ' ' .$busqueda->emp_middle_name. "*\n";
       $body.="Celular: *".$busqueda->emp_mobile_no."*\n";
       $body.="Correo electrónico: *".$busqueda->emp_email_id."*\n";
       $body.="Te solicitamos contactarlo a la brevedad para que pueda darte las indicaciones inmediatas. Tu asesor académico será enterado y le solicitaremos que te oriente.";
      Sesiones::actualizarPaso($to,'menu');
    }

}elseif (($paso=='dudas_entregas')) {
  $busqueda = BatchStu::buscarFacilitador($request->data['body']);
    if ($busqueda === null) {
        $body ="No se encontraron resultados para el criterio de búsqueda, intenta nuevamente \n Escribe tu celular a 10 dígitos, curp o usuario";
    } else {
      $body ="Tu asesor académico es: *".$busqueda->emp_first_name. ' ' .$busqueda->emp_last_name. ' ' .$busqueda->emp_middle_name. "*\n";
       $body.="Celular: *".$busqueda->emp_mobile_no."*\n";
       $body.="Correo electrónico: *".$busqueda->emp_email_id."*\n";
       $body.="Te solicitamos contactarlo a la brevedad para que pueda darte las indicaciones inmediatas. Tu asesor académico será enterado y le solicitaremos que te oriente.";
      Sesiones::actualizarPaso($to,'menu');
    }


}elseif (($paso=='nombre_incorrecto')) {
  //stu_first_name
  // $api=$client->sendChatMessage($to,$paso2,$priority,$referenceId);
  if($paso2=='' || empty($paso2)){
    $busqueda = BatchStu::buscarFacilitador($request->data['body']);
      if ($busqueda === null) {
          $body ="No se encontraron resultados para el criterio de búsqueda, intenta nuevamente \n Escribe tu celular a 10 dígitos, curp o usuario";
      } else {
        $body ="Tu nombre está escrito de la siguiente manera: *".$busqueda->stu_first_name." ".$busqueda->stu_last_name." ".$busqueda->stu_middle_name."*\n";
        $body.='Escibe la ortografía correcta de tu nombre en mayúsculas';
        Sesiones::actualizarPaso2($to,'introducirnombre');
        // Sesiones::actualizarPaso($to,'menu');
      }
  }elseif($paso2=='introducirnombre'){
    //$request->data['body'] //esto lo van a enviar al whats app del otro cliente
    $body='¡Gracias! Hemos registrado tu solicitud, en un plazo de 24 horas. Recibirás la confirmación del cambio en la ortografía de tu nombre.¡ Saludos!';

    Sesiones::actualizarPaso($to,'menu');
    Sesiones::actualizarPaso2($to,'');
  }


}elseif (($paso=='accesos')) {
  $busqueda = BatchStu::buscarFacilitador($request->data['body']);
  if ($busqueda === null) {
      $body ="No se encontraron resultados para el criterio de búsqueda, intenta nuevamente \n Escribe tu celular a 10 dígitos, curp o usuario";
  } else {
    if ($busqueda->extraer_lms=='1') {
        $urlc='https://www.conrumbo.org/campusvirtual';
    } elseif ($busqueda->extraer_lms=='2') {
        $urlc='https://www.toplineconsultores.com/campus';
    } elseif ($busqueda->extraer_lms=='3') {
        $urlc='https://app.teacherspro.com/#/login';
    }
    $body ="Sus datos de ingreso son: *".$urlc."*\n";
     $body.="Usuario: *".$busqueda->usuario."*\n";
     $body.="Contraseña: *".$busqueda->contrasenia."*\n";
     $body2="¿Te puedo ayudar en algo más? \n\n".$menuprincipal;
    Sesiones::actualizarPaso($to,'menu');
  }
}elseif (($paso=='constancia')) {
$busqueda = BatchStu::buscarPorCurpOUsuario($request->data['body']);

  if ($busqueda === null) {
      // No se encontraron resultados
      $body ="No se encontraron resultados para el criterio de búsqueda, intenta nuevamente \n Por Favor escribe tu teléfono, curp o usuario para buscar tu constancia";
  } else {
      // $body ='Encontramos esta constancia:'.json_encode($busqueda);

      $califAprobatoria = $busqueda->calif_aprobatoria ?? 0;
      $califAprobatoria = 80;
      $calificacionFinal = $busqueda->calificacion_final ?? 0;

      if ($califAprobatoria <= $calificacionFinal) {
        $document="https://sicaedu.com/control/index.php?r=site/constancia&id=".$busqueda->id;
         $documentContent = file_get_contents($document);

        $filename = 'Constancia_'.$busqueda->stu_first_name.' '.$busqueda->stu_last_name.' '.$busqueda->stu_middle_name.'.pdf';

        // Guarda el documento en el directorio public/documents
        Storage::disk('public')->put('documents/' . $filename, $documentContent);



        // $rutaDeArchivo = Storage::disk('public')->url('documents/' . $filename);
        $rutaDeArchivo = route('documents.show', ['filename' => $filename]);
        $document = $rutaDeArchivo;
        $caption="Constancia ".$busqueda->stu_first_name.' '.$busqueda->stu_last_name.' '.$busqueda->stu_middle_name;
        // $caption=$rutaDeArchivo;

        $caption ='Aquí tienes tu constancia';
        // $api=$client->sendChatMessage($to,$body,$priority,$referenceId);
        $body=false;
        $api=$client->sendDocumentMessage($to,$filename,$document,$caption);
        //$to,$filename,$document,$caption="",$priority=10,$referenceId="",$nocache=false
        // Storage::disk('public')->delete('documents/' . $filename);

        Sesiones::actualizarPaso($to,'menu');

      } else {
          $body ='Este requerimiento será enviado a nuesto Ejecutivo de Atención a Usuarios para su atención personalizada, en breve le contactará.';
          //enviar a usuario
          Sesiones::actualizarPaso($to,'menu');
      }


  }

}
if($body){
  $api=$client->sendChatMessage($to,$body,$priority,$referenceId);
}

if($body2){
  $api=$client->sendChatMessage($to,$body2,$priority,$referenceId);
}
// print_r($api);

        return response()->json(['success' => true]);
    }
    public function storage(Request $request)
    {

    }
    // protected $primaryKey = 'id';
}
 ?>
