<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Perfume;
use App\Models\Perfumedetalle;

class PerfumeController extends Controller
{
    public function insertardetalle($datos)
    {
      $datos=base64_decode($datos);
      $datos = json_decode($datos);

      foreach ($datos as $perfumeData) {
        // Buscar un perfume existente con el mismo id_
        $existingPerfume = Perfumedetalle::where('id_', $perfumeData->x)->first();

        if ($existingPerfume) {
            // Si ya existe, actualizamos los demás campos
            $existingPerfume->fill([
                'nombre' => $perfumeData->n,
                'precio' => $perfumeData->p,
            ])->save();
        } else {
            // Si no existe, creamos un nuevo registro
            $perfume = new Perfumedetalle();
            $perfume->id_ = $perfumeData->x;
            $perfume->nombre = $perfumeData->n;
            $perfume->precio = $perfumeData->p;
            $perfume->save();
        }
    }


    }
    public function store2($datos)
    {
      $datos=base64_decode($datos);

      var_dump($datos);
      $datos = json_decode($datos);

      // $perfumes = json_decode($request->getContent(), true);

        // Iterar sobre los perfumes y guardarlos en la base de datos
        foreach ($datos as $perfumeData) {
          // Buscar un perfume existente con el mismo id_
          $existingPerfume = Perfume::where('id_', $perfumeData->x)->first();

          if ($existingPerfume) {
              // Si ya existe, actualizamos los demás campos
              $existingPerfume->fill([
                  'link' => 'https://www.fragrancenet.com/'. $perfumeData->l,
                  'nombre' => $perfumeData->n,
                  'sexo' => '',
                  'tipo' => '',
              ])->save();
          } else {
              // Si no existe, creamos un nuevo registro
              $perfume = new Perfume();
              $perfume->id_ = $perfumeData->x;
              $perfume->link = 'https://www.fragrancenet.com/'. $perfumeData->l;
              $perfume->nombre = $perfumeData->n;
              $perfume->sexo = '';
              $perfume->tipo = '';
              $perfume->save();
          }
      }




        // Retornar una respuesta indicando que el perfume ha sido creado exitosamente
        return response()->json(['message' => 'Perfume creado exitosamente'], 201);
    }
    public function store(Request $request)
    {

      $perfumes = json_decode($request->getContent(), true);

        // Iterar sobre los perfumes y guardarlos en la base de datos
        foreach ($perfumes as $perfumeData) {
          $perfume = new Perfume();
          $perfume->id_ = $request->id;
          $perfume->imagen = $request->imagen;
          $perfume->link = $request->link;
          $perfume->nombre = $request->nombre;
          $perfume->sexo = $request->sexo;
          $perfume->tipo = $request->tipo;
          $perfume->save();
        }




        // Retornar una respuesta indicando que el perfume ha sido creado exitosamente
        return response()->json(['message' => 'Perfume creado exitosamente'], 201);
    }
}
