<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * objectfs null logger class.
 *
 * @package   tool_objectfs
 * @author    Kenneth Hendricks <kennethhendricks@catalyst-au.net>
 * @copyright Catalyst IT
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace tool_objectfs\log;

defined('MOODLE_INTERNAL') || die();

require_once($CFG->dirroot . '/admin/tool/objectfs/lib.php');

/**
 * [Description null_logger]
 */
class null_logger extends objectfs_logger {
    /**
     * log_object_read
     * @param mixed $readname
     * @param mixed $objectpath
     * @param int $objectsize
     *
     * @return void
     */
    public function log_object_read($readname, $objectpath, $objectsize = 0) {
        return;
    }

    /**
     * log_object_move
     * @param mixed $movename
     * @param mixed $initallocation
     * @param mixed $finallocation
     * @param mixed $objecthash
     * @param int $objectsize
     *
     * @return void
     */
    public function log_object_move($movename, $initallocation, $finallocation, $objecthash, $objectsize = 0) {
        return;
    }

    /**
     * log_object_query
     * @param mixed $queryname
     * @param mixed $objectcount
     * @param int $objectsum
     *
     * @return void
     */
    public function log_object_query($queryname, $objectcount, $objectsum = 0) {
        return;
    }
}
