Adaptable - the most adaptable Moodle theme
===========================================
Adaptable is a highly customisable responsive Moodle theme:

- Additional customisable information / marketing blocks.
- Additional header navigation.
- Additional layout settings.
- Alternative frontpage course styles.
- Alternative slider.
- Course tabbed layout builder.
- Custom category headers (Sponsors only functionality).
- Custom frontpage courses list.
- Customisable fonts (Google Fonts).
- Customisable login page (Sponsors only functionality).
- Customisable navigation bar.
- Dashboard layout builder.
- Dismissible bootstrap alerts (Sponsors only functionality).
- Footer block layout builder.
- Forum post email template override.
- Frontpage layout builder.
- Fully customisable colours.
- Fully customisable block styles (including Font Awesome icons).
- Fully customisable buttons.
- My courses menu (Sponsors only functionality).
- News ticker (Sponsors only functionality).
- Print settings.
- Privacy API.
- Responsive layout options.
- Social icons.
- Tools menus (Sponsors only functionality).
- Two and three row header style options.
- User favourites menu - per user (Sponsors only functionality).
- User profile options.

In addition many fields (menus, news items, alerts and help links) can be targeted using custom profile fields, thus it is possible
to present different users with different navigation items and notices.  It is also possible for individual users to customize where
they want top menu navigation to appear (disable, home pages only, site wide) using custom profile fields.

Adaptable has a lot of settings and may seem daunting at first, my advice is to simply install with the default settings and play
with it afterwards.

With a little time you should be able to setup an attractive Moodle site with a high degree of individuality without without
knowing any CSS.

Current developer:
G J Barnard MSc. BSc(Hons)(Sndw). MBCS. CEng. CITP. PGCE.  [Moodle profile](https://moodle.org/user/profile.php?id=442195) and [Web profile](https://about.me/gjbarnard)

This theme has been developed by the following:

- Jeremy Hopkins (Coventry University)
- Fernando Acedo (3bits elearning solutions)
- Manoj Solanki (Coventry University)
- G J Barnard MSc. BSc(Hons)(Sndw). MBCS. CEng. CITP. PGCE.

Required release of Moodle
==========================
This version works with Moodle 4.5 version 2024100700.00 (Build: 20241007) and above within the MOODLE_405_STABLE branch until the
next release.

Please ensure that your hardware and software complies with 'Requirements' in '[Installing Moodle](https://docs.moodle.org/405/en/Installing_Moodle)'.

Installation
============
 1. Ensure you have the release of Moodle as stated above in 'Required release of Moodle'.  This is essential as the
    theme relies on underlying core code that is out of my control.
 2. Login as an administrator and put Moodle in 'Maintenance Mode' so that there are no users using it bar you as the administrator.
 3. Copy the extracted 'adaptable' folder to the '/theme/' folder.
 4. Go to 'Site administration' -> 'Notifications' and follow standard the 'plugin' update notification.
 5. Select as the theme for the site.
 6. Put Moodle out of Maintenance Mode.

Upgrading
=========
 1. Ensure you have the release of Moodle as stated above in 'Required release of Moodle'.  This is essential as the
    theme relies on underlying core code that is out of my control.
 2. Login as an administrator and put Moodle in 'Maintenance Mode' so that there are no users using it bar you as the administrator.
 3. Make a backup of your old 'adaptable' folder in '/theme/' and then delete the folder.
 4. Copy the replacement extracted 'adaptable' folder to the '/theme/' folder.
 5. Go to 'Site administration' -> 'Notifications' and follow standard the 'plugin' update notification.
 6. If automatic 'Purge all caches' appears not to work by lack of display etc. then perform a manual 'Purge all caches'
    under 'Home -> Site administration -> Development -> Purge all caches'.
 7. Put Moodle out of Maintenance Mode.

Uninstallation
==============
 1. Put Moodle in 'Maintenance Mode' so that there are no users using it bar you as the administrator.
 2. Change the theme to another theme of your choice.
 3. In '/theme/' remove the folder 'adaptable'.
 4. Go to 'Site administration' -> 'Notifications' and follow standard the 'plugin' update notification.
 5. Put Moodle out of Maintenance Mode.

Versioning
==========
Adaptable is maintained under the Semantic Versioning 2.0.0 guidelines as much as possible. Releases will be numbered with the
following format:

major.minor.patch

and following these guidelines:

- Breaking backward compatibility bumps the major (and resets the minor and patch)
- New additions without breaking backward compatibility bumps the minor (and resets the patch)
- Bug fixes and misc changes bumps the patch

For more information on SemVer, please visit http://semver.org.


Acknowledgments
===============
Development contributions from:

- Justin Hunt
- Leonid Chernyavskiy
- COMETE (UniversitÃ© Paris Nanterre)
- Marina Glancy
- Nick Phillips
- BjÃ¶rn BettzÃ¼che
- Michael Milette
- Bas Brands
- Gareth Barnard
- KonrÃ¡d LÅ‘rinczi
- Mathieu Domingo

Testing:

- Andrew Walding
- Alexander Goryntsev

Translation:

- GermÃ¡n Valero (EspaÃ±ol - MÃ©xico)
- Jordi Rodilla (CatalÃ   - Andorra)

Licenses
========
Adaptable is licensed under:

- [GPL v3 (GNU General Public License)](http://www.gnu.org/licenses)

Google Fonts released under:

- [SIL Open Font License v1.1](http://scripts.sil.org/OFL)
- [Apache 2 license](https://www.apache.org/licenses/LICENSE-2.0)
- The Ubuntu fonts use the [Ubuntu Font License v1.0](http://font.ubuntu.com/ufl/ubuntu-font-licence-1.0.txt)

The Font Awesome font (by Dave Gandy) http://fontawesome.io, is licensed under:

- Fonts: [SIL Open Font License v1.1](http://scripts.sil.org/OFL)
- Documentation: CC BY 3.0
- CSS and SASS files are licensed under:
[MIT License](https://opensource.org/licenses/mit-license.html)
