<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_eadtraining', language 'es_mx', version '4.5'.
 *
 * @package     theme_eadtraining
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['access_course'] = 'Acceder al curso';
$string['access_course_buy'] = 'Detalles del curso';
$string['acctoolbar_access_declaration'] = 'Declaración de accesibilidad';
$string['acctoolbar_btn_bright'] = 'Contraste brillante';
$string['acctoolbar_btn_cursor_black'] = 'Cursor negro grande';
$string['acctoolbar_btn_cursor_white'] = 'Cursor blanco grande';
$string['acctoolbar_btn_font_down'] = 'Disminuir texto';
$string['acctoolbar_btn_font_readable'] = 'Texto legible';
$string['acctoolbar_btn_font_up'] = 'Aumentar texto';
$string['acctoolbar_btn_images_titles'] = 'Títulos de imágenes';
$string['acctoolbar_btn_invert'] = 'Contraste invertido';
$string['acctoolbar_btn_monochrome'] = 'Pantalla sin color';
$string['acctoolbar_btn_open'] = 'Menú de accesibilidad';
$string['acctoolbar_btn_underline_headers'] = 'Subrayar encabezados';
$string['acctoolbar_btn_underline_links'] = 'Subrayar enlaces';
$string['acctoolbar_btn_zoom_in'] = 'Ampliar pantalla';
$string['acctoolbar_content_block_header'] = 'Resaltar contenido';
$string['acctoolbar_contrast_block_header'] = 'Contraste de color';
$string['acctoolbar_debug_contacts'] = 'Reportar un problema de accesibilidad';
$string['acctoolbar_disable_animattions'] = 'Bloquear animaciones';
$string['acctoolbar_dyslexic'] = 'Fuente legible para dislexia';
$string['acctoolbar_image_without_alt'] = 'Imagen sin texto';
$string['acctoolbar_keyboard_root'] = 'Navegación con teclado';
$string['acctoolbar_reset_all_settings'] = 'Restablecer configuración';
$string['acctoolbar_text_block_header'] = 'Tamaño de texto';
$string['acctoolbar_toolbar'] = 'Accesibilidad';
$string['acctoolbar_zoom_block_header'] = 'Acercar';
$string['add_block'] = '+ Agregar nuevo bloque';
$string['advancedsettings'] = 'Configuración avanzada';
$string['background_profile_image'] = 'Imagen de fondo predeterminada del curso';
$string['background_profile_image_desc'] = 'Define una imagen de fondo predeterminada para el encabezado de todos los cursos. Esta imagen se mostrará en la parte superior de la página del curso y se puede reemplazar individualmente en la configuración del curso.';
$string['backgroundimage'] = 'Imagen de fondo';
$string['backgroundimage_desc'] = 'La imagen que se mostrará como fondo del sitio. La imagen de fondo que subas aquí reemplazará la imagen de fondo en los archivos preestablecidos de tu tema.';
$string['brandcolor'] = 'Color principal de la interfaz';
$string['brandcolor_background_menu'] = 'Aplicar el color de marca al fondo del menú';
$string['brandcolor_background_menu_desc'] = 'Esta configuración define si el color establecido en "Color de marca" se aplicará a los elementos del menú o al fondo del menú.<br>Si se aplica al fondo, el texto del menú se mostrará en blanco para asegurar un contraste adecuado.';
$string['brandcolor_desc'] = 'Configura el color de resaltado usando la selección anterior o eligiendo de la paleta de abajo.';
$string['cachedef_course_cache'] = 'Caché de datos del curso';
$string['cachedef_course_module_cache'] = 'Caché de módulos del curso';
$string['cachedef_css_cache'] = 'Caché de hojas de estilo CSS';
$string['cachedef_data_cache'] = 'Caché de datos';
$string['cachedef_frontpage_cache'] = 'Caché de la página principal';
$string['choosereadme'] = 'Ead Training es un tema moderno y altamente personalizable. Este tema está diseñado para usarse directamente o como tema padre al crear nuevos temas que utilicen Bootstrap 4.';
$string['configtitle'] = 'Ead Training';
$string['course_colors_desc'] = 'Establece el color de resaltado solo para este curso o elige una de las muestras a continuación.';
$string['course_colors_title'] = 'Sobrescribir el color en este curso';
$string['course_summary'] = 'Mostrar el resumen del curso antes del Curso';
$string['course_summary_banner'] = 'Mostrar el resumen del curso antes del Curso';
$string['course_summary_banner_desc'] = 'Si está habilitado, el resumen del curso se mostrará antes del contenido principal del curso en la página del curso.';
$string['course_summary_banner_edit'] = 'Editar la imagen del banner de este curso';
$string['course_summary_banner_none'] = 'Sin encabezado';
$string['course_summary_banner_simple'] = 'Encabezado simple con información';
$string['course_summary_banner_title'] = 'Encabezado con banner';
$string['course_summary_desc'] = 'Si está habilitado, el resumen del curso se mostrará antes del contenido principal del curso en la página del curso.';
$string['courseindexoptions'] = 'Opciones del índice del curso';
$string['coursesettings'] = 'Curso';
$string['delete_block_confirm'] = '¿Está seguro de que desea eliminar el bloque?';
$string['delete_block_success'] = 'Bloque eliminado correctamente';
$string['delete_block_title'] = 'Eliminar bloque';
$string['details-completaram'] = 'Curso completado';
$string['details-emprogresso'] = 'En progreso';
$string['details-not-access'] = 'Nunca accedido';
$string['details-teachers'] = 'Docentes';
$string['details-users'] = 'Estudiantes';
$string['edit_block'] = 'Editar bloque';
$string['error_invalidscss'] = 'SCSS no válido: {$ a}';
$string['favicon'] = 'Favicon';
$string['favicon_desc'] = 'El favicon se muestra junto al título de la página en la pestaña del navegador. Se muestra un favicon de Moodle si no se proporciona un favicon personalizado.';
$string['footer_background_color'] = 'Color de fondo del pie de página';
$string['footer_background_color_desc'] = 'Selecciona el color de fondo para la sección del pie de página del sitio. Déjalo en blanco para usar el color primario.';
$string['footer_copywriter'] = 'Hecho con ❤️ por';
$string['footer_heading'] = 'Bloque {$a}';
$string['footer_heading_description_desc'] = '<ul>
  <li><strong>Sin bloques llenados:</strong> no se mostrará el pie de página.</li>
  <li><strong>1 bloque llenado:</strong> el contenido se mostrará como texto, sin formato de bloque.</li>
  <li><strong>2, 3 o 4 bloques llenados:</strong> el tema ajustará automáticamente el diseño para mostrar los bloques de forma adaptable y proporcional.</li>
</ul>
Llena solo los bloques que necesites, el tema se encarga del resto.';
$string['footer_heading_description_title'] = 'El tema se adapta automáticamente al número de bloques de pie de página que llenes:';
$string['footer_html'] = 'Bloque de pie de página {$a} HTML';
$string['footer_html_desc'] = 'Agrega el código HTML personalizado que se mostrará en el bloque de pie de página {$a}.';
$string['footer_show_copywriter'] = 'Mostrar Hecho con ❤️';
$string['footer_show_copywriter_desc'] = 'Desmarque si desea ocultar el "Hecho con ❤️"';
$string['footer_title'] = 'Título del bloque {$a}';
$string['footer_title_desc'] = 'Establezca el título que aparecerá encima del contenido HTML en el bloque de pie de página {$a}.';
$string['footersettings'] = 'Configuraciones del pie de página';
$string['frontpage_add_block'] = 'Agregar nuevo bloque';
$string['frontpage_add_block_title'] = 'Seleccione el bloque de muestra para agregar';
$string['frontpage_change_editor'] = '¿Crear la página de inicio con el editor de páginas?';
$string['frontpage_enable_editing'] = 'Habilite la edición para agregar elementos a la página de inicio';
$string['generalsettings'] = 'Configuraciones generales';
$string['homesettings'] = 'Configuraciones de inicio';
$string['imageacceptedtypes'] = 'Solo se permiten archivos de imagen del tipo {$a}';
$string['language_all'] = 'Todos los idiomas disponibles';
$string['loginbackgroundimage'] = 'Imagen de fondo de la página de inicio de sesión';
$string['loginbackgroundimage_desc'] = 'La imagen que se mostrará como fondo en la página de inicio de sesión.';
$string['loginlogo'] = 'Logo PNG/SVG para la pantalla de inicio de sesión';
$string['loginlogo_desc'] = 'Suba el logo en formato PNG o SVG para que aparezca en la pantalla de inicio de sesión. El logo debe ser claro y representar la identidad visual de su institución o empresa, garantizando una experiencia de inicio de sesión profesional y consistente para los usuarios.';
$string['loginsettings'] = 'Configuraciones del ingreso';
$string['logintheme'] = 'Tema de pantalla de ingreso';
$string['logintheme_aurora'] = 'Aurora';
$string['logintheme_clean-minimal'] = 'Limpio Mínimo';
$string['logintheme_clean-outline'] = 'Limpio Esqueña';
$string['logintheme_dark-elegante'] = 'Oscuro elegante';
$string['logintheme_desc'] = 'Seleccionar el tema visual que será mostrado en pantalla de ingreso.';
$string['logintheme_selva-canopy'] = 'Pabellón de Selva';
$string['pluginname'] = 'Ead Training';
$string['preview'] = 'Vista previa del bloque';
$string['privacy:drawerblockclosed'] = 'La preferencia actual para el cajón de bloques está cerrada.';
$string['privacy:drawerblockopen'] = 'La preferencia actual para el cajón de bloques está abierta.';
$string['privacy:drawerindexclosed'] = 'La preferencia actual para el cajón del índice está cerrada.';
$string['privacy:drawerindexopen'] = 'La preferencia actual para el cajón del índice está abierta.';
$string['privacy:metadata'] = 'El tema Ead Training no almacena ningún dato personal de ningún usuario.';
$string['privacy:metadata:preference:draweropenblock'] = 'La preferencia del usuario para ocultar o mostrar el cajón con bloques.';
$string['privacy:metadata:preference:draweropenindex'] = 'La preferencia del usuario para ocultar o mostrar el cajón con el índice del curso.';
$string['privacy:metadata:preference:draweropennav'] = 'La preferencia del usuario para ocultar o mostrar el menú de navegación del cajón.';
$string['quickstart_alert_notadd'] = 'No es posible cambiar el banner de la página de inicio después de haberlo agregado. Para modificarlo, debe ir a la <a href="{$a}/">página de inicio</a> y eliminar el banner existente.';
$string['quickstart_alert_notdelete'] = 'No es posible eliminar los bloques agregados aquí. Para borrarlos, vaya a la <a href="{$a}/">página de inicio</a> y elimine los bloques que ya no desee.';
$string['quickstart_banner-recreation-room'] = 'Sala de recreación';
$string['quickstart_banner-saved'] = 'Las configuraciones se han guardado correctamente.';
$string['quickstart_course_choose_below'] = 'O elija un banner de abajo';
$string['quickstart_course_upload_or_choose'] = 'Suba una imagen o elija el tipo de banner que desee';
$string['quickstart_home_pagebuilder'] = 'Inicio con editor de páginas';
$string['quickstart_home_pagebuilder_desc'] = 'Interfaz personalizable con secciones editables.';
$string['quickstart_home_selectsections'] = 'Seleccione las secciones deseadas:';
$string['quickstart_home_selectstyle'] = 'Elija el estilo de inicio';
$string['quickstart_home_traditional'] = 'Inicio tradicional de Moodle';
$string['quickstart_home_traditional_desc'] = 'Página de inicio predeterminada de Moodle con bloques y cursos. Haga clic en el botón de abajo para editar las configuraciones del sistema.';
$string['quickstart_settings_link'] = '<div class="card mb-5">
<div class="card-header">Inicio rápido</div>
<div class="card-body"><a href="{$a}">Acceda a la Guía de inicio rápido</a> y use el configurador intuitivo para personalizar estas y otras configuraciones del tema Ead Training.</div>
</div>';
$string['quickstart_title'] = 'Centro de configuraciones del tema';
$string['region-side-pre'] = 'Derecha';
$string['settings_accessibility'] = 'Habilitar opciones de accesibilidad';
$string['settings_accessibility_desc'] = 'Permite personalizar opciones para mejorar la accesibilidad de la plataforma, como contraste, tamaño de fuente y navegación con teclado.';
$string['settings_accessibility_heading'] = 'Accesibilidad';
$string['settings_icons_change_icons'] = 'Cambiar el ícono predeterminado en la lista de cursos';
$string['settings_icons_color_icon'] = 'Establezca un color personalizado para el ícono.';
$string['settings_icons_color_icon_desc'] = 'Seleccione el color de fondo para el ícono mostrado en la lista de cursos. Deje en blanco para usar el color predeterminado del tema.';
$string['settings_icons_upload_icon'] = 'Subir el ícono personalizado.';
$string['settings_icons_upload_image'] = 'Imagen del bloque';
$string['settings_icons_upload_image_desc'] = 'Si se proporciona una imagen, el tema convertirá la fila del módulo en un bloque, usando la imagen como fondo. La imagen debe tener una relación de aspecto 16:9.';
$string['showfooter'] = 'Mostrar pie de página';
$string['top_color_heading'] = 'Color de desplazamiento superior';
$string['top_scroll_background_color'] = 'Color de fondo del menú superior al desplazarse';
$string['top_scroll_background_color_desc'] = 'Establecer el color de fondo al desplazarse por la página.';
$string['top_scroll_fix'] = 'Fijar el menú al desplazarse por la página';
$string['top_scroll_fix_desc'] = 'Cuando está habilitado, el menú quedará fijado en la parte superior de la pantalla mientras se desplaza por la página, asegurando un fácil acceso a las opciones del menú.';
$string['userprofilesettings'] = 'Perfil del usuario';
