<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_whatsapp_messenger', language 'es_mx', version '4.5'.
 *
 * @package     block_whatsapp_messenger
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesstoken'] = 'Token de Acceso a WhatsApp';
$string['accesstoken_desc'] = 'Su token de acceso a API de WhatsApp Business';
$string['allstudents'] = 'Todos los estudiantes';
$string['apiversion'] = 'Versión de API';
$string['apiversion_desc'] = 'Versión de API de WhatsApp (predeterminado: v17.0)';
$string['debugmode'] = 'Modo de depuración';
$string['message'] = 'Mensaje';
$string['messagefailed'] = 'No se pudo enviar mensaje a {$a} estudiante(s)';
$string['messageplaceholder'] = 'Escriba aquí su mensaje...';
$string['messagesent'] = 'Mensaje enviado exitosamente a {$a} estudiante(s)';
$string['nopermission'] = 'Usted no tiene permiso para enviar mensajes WhatsApp.';
$string['norecipients'] = 'No se encontraron destinatarios con números de teléfono.';
$string['phonenumberid'] = 'ID de Número Telefónico';
$string['phonenumberid_desc'] = 'Su ID del número de teléfono de WhasApp Business';
$string['pluginname'] = 'Mensajeador WhatsApp';
$string['privacy:metadata:block_whatsapp_log:courseid'] = 'La ID del curso adonde se envió el mensaje';
$string['privacy:metadata:block_whatsapp_log:message'] = 'El contenido del mensaje enviado';
$string['privacy:metadata:block_whatsapp_log:recipient'] = 'La ID del usuario que recibió el mensaje';
$string['privacy:metadata:block_whatsapp_log:response'] = 'La respuesta de API de WhatsApp';
$string['privacy:metadata:block_whatsapp_log:status'] = 'El estado del envío del mensaje (exitoso/fallido)';
$string['privacy:metadata:block_whatsapp_log:timecreated'] = 'La hora de cuando se envió el mensaje';
$string['privacy:metadata:block_whatsapp_log:userid'] = 'La ID del usuario que envió el mensaje';
$string['privacy:metadata:whatsapp_business_api:coursename'] = 'El nombre del curso (si se usa como plantilla)';
$string['privacy:metadata:whatsapp_business_api:firstname'] = 'El nombre del destinatario (si se usa como plantilla)';
$string['privacy:metadata:whatsapp_business_api:lastname'] = 'El apellido del destinatario (si se usa como plantilla)';
$string['privacy:metadata:whatsapp_business_api:message'] = 'El contenido del mensaje que está siendo enviado';
$string['privacy:metadata:whatsapp_business_api:phone'] = 'El número de teléfono del destinatario';
$string['recipient'] = 'Destinatario';
$string['sendingsuccess'] = 'Enviados: {$a->sent}, Fallidos: {$a->failed} de un total de {$a->total} destinatarios';
$string['sendmessage'] = 'Enviar mensaje';
$string['templatecontent'] = 'Contenido de Plantilla (para referencia)';
$string['templatecontent_desc'] = 'Pegue aquí su plantilla de WhatsApp como referencia. El plugin analizará {{placeholders}} y los asignará a los datos disponibles.<br><br>
<strong>Reemplazables disponibles:</strong><br>
{firstname} - Nombre del estudiante<br>
{lastname} - Apellido(s) del estudiante<br>
{fullname} - Nombre completo del estudiante<br>
{email} - Correo electrónico del estudiante<br>
{coursename} - Nombre del curso<br>
{courseid} - ID del curso<br>
{courseshortname} - Nombre corto del curso<br>
{message} - Contenido del mensaje introducido por el profesor<br>
{teachername} - Nombre completo del profesor<br>
{sitename} - Nombre del sitio<br>
{date} - Fecha actual (formato corto)<br>
{datetime} - Fecha y hora actuales<br>
{time} - Hora actual<br><br>
<strong>Plantilla de ejemplo:</strong><br>
Hola {firstname}, aquí tienes un mensaje de nuestro equipo de soporte:<br>
*Contenido:* {message}<br>
*Fecha:* {date}<br>
Atentamente, Equipo de Soporte.';
$string['templatelang'] = 'Idioma de la plantilla';
$string['templatelang_desc'] = 'Código del idioma de la plantilla (e.g., en, en_US, he_IL). Predeterminado: en';
$string['templatename'] = 'Nombre de plantilla';
$string['whatsapp_messenger:addinstance'] = 'Añadir un nuevo bloque de Mensajero de WhatsApp';
$string['whatsapp_messenger:myaddinstance'] = 'Añadir un nuevo bloque de Mensajero de WhatsApp al Tablero';
$string['whatsapp_messenger:sendmessage'] = 'Enviar mensajes WhatsApp a estudiantes';
